/*
* sstar_rpmsg.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/

/*
 * @file rpmsg_dualos.h
 *
 * @brief Global header file for sstar rpmsg_dualos
 *
 * @ingroup rpmsg_dualos
 */
#ifndef __RPMSG_DUALOS_H__
#define __RPMSG_DUALOS_H__
#include <linux/rpmsg.h>

#include "rpmsg_dualos_common.h"

// dualos interos call APIs
struct dualos_interos_node;

struct dualos_interos_node *dualos_interos_node_alloc(int local_addr, int remote_addr);
void dualos_interos_node_release(struct dualos_interos_node *dnode);

int dualos_interos_recv(struct dualos_interos_node *dnode,
			struct dualos_interos_datagram *data,
			unsigned int *src,
			signed long timeout);
int dualos_interos_call_to(struct dualos_interos_node *dnode,
			int dst,
			unsigned int arg0, unsigned int arg1,
			unsigned int arg2, unsigned int arg3,
			struct dualos_interos_datagram *resp);
int dualos_interos_call(struct dualos_interos_node *dnode,
			unsigned int arg0, unsigned int arg1,
			unsigned int arg2, unsigned int arg3,
			struct dualos_interos_datagram *resp);

// low level RPMSG APIs
bool dualos_rpmsg_wait_remote_device(int soc_id, int os_id, signed long timeout);
struct rpmsg_endpoint *dualos_rpmsg_create_ept(int soc_id, int os_id,
					rpmsg_rx_cb_t cb, void *priv,
					struct rpmsg_channel_info chinfo);
int dualos_rpmsg_destroy_ept(struct rpmsg_endpoint *ept);
bool dualos_rpmsg_get_remote_adaptor_status(int soc_id, int os_id);
void dualos_rpmsg_set_remote_adaptor_status(int addr, bool ready);

#endif /* __RPMSG_DUALOS__H__ */
